#! ruby -Ks
require "jcode"
require "fileutils"

class Profile
	def initialize fileName
		@hash = {}
		@file = File.open(fileName)
		
		appName = ''
		@hash[appName] = {}
		
		@file.each do |line|
			line.lstrip!()
			if (line.empty?() || line[0] == ?#)
				next
			end
			
			# appName ǂ
			if (line[0] == ?[)
				line.slice!(0, 1)
				appName = line[0...line.index(']')]
				@hash[appName] = {}
				next
			end
			
			i = line.index('=')
			keyName = line[0...i]
			keyName.lstrip!()
			keyName.rstrip!()
			value = line[(i+1)..(line.length()-1)]
			value.lstrip!()
			value.rstrip!()
			(@hash[appName])[keyName] = value
		end
			
		@file.close()
	end
	
	def getInt appName, keyName, default
		return self.getString(appName, keyName, default).to_i()
	end
	
	def getString appName, keyName, default
		if (!(@hash.key?(appName)))
			return default
		end
		if (!(@hash[appName].key?(keyName)))
			return default
		end
		return ((@hash[appName])[keyName])
	end
end

