#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# С
proc showAbout {} {
	global gApplicationName tcl_version tk_version
	set ver "Version 1.00"
	catch "destroy .about"
	toplevel .about
	wm title .about [format "%s ΥС" $gApplicationName]
	wm resizable .about 0 0
	label	.about.l1 -text $gApplicationName -bd 5
	label	.about.l2 -text $ver
	label	.about.l3 -text "copyright (c) 2004 kurima" -bd 5
	label	.about.l4 -text "KurimaYoshida@hotmail.com" -bd 5
	label	.about.l5 -text " tcl$tcl_version tk$tk_version Ǥ" -bd 5
	button	.about.b1 -text "OK" -command "destroy .about"
	pack	.about.l1 .about.l2 .about.l3 .about.l4 .about.l5 .about.b1 -side top
}

# ˥塼
proc createMenu {} {
	menu .menu
	.menu add cascade -label {ե(F)} -underline 5 -menu .menu.file
	.menu add cascade -label {Խ(E)} -underline 3 -menu .menu.edit
	.menu add cascade -label {(O)} -underline 3 -menu .menu.form
	.menu add cascade -label {إ(H)} -underline 4 -menu .menu.help

	menu .menu.file -tearoff no
	.menu.file add command -label {(N)} -underline 3 -accelerator "Ctrl+N" -command newFile
	.menu.file add command -label {(O)...} -underline 3 -accelerator "Ctrl+O" -command loadFile
	.menu.file add command -label {¸(S)} -underline 5 -accelerator "Ctrl+S" -command overwriteFile
	.menu.file add command -label {̾դ¸(A)...} -underline 8 -command saveFileAs
	.menu.file add separator
	.menu.file add command -label {(P)} -underline 3 -accelerator "Ctrl+P"
	.menu.file add separator
	.menu.file add command -label {λ(X)} -underline 3 -command exitApplication

	menu .menu.edit -tearoff no
	.menu.edit add command -label {᤹(U)} -underline 5 -accelerator "Ctrl+Z" -command undo
	.menu.edit add command -label {ľ(R)} -underline 5 -accelerator "Ctrl+Y" -command redo
	.menu.edit add separator
	.menu.edit add command -label {ڤ(T)} -underline 5 -accelerator "Ctrl+X" -command cut
	.menu.edit add command -label {ԡ(C)} -underline 4 -accelerator "Ctrl+C" -command copy
	.menu.edit add command -label {Žդ(P)} -underline 5 -accelerator "Ctrl+V" -command paste
	.menu.edit add command -label {(L)} -underline 3 -accelerator "Del" -command delete
	.menu.edit add separator
	.menu.edit add command -label {(F)...} -underline 3 -accelerator "Ctrl+F" -command {search 0}
	.menu.edit add command -label {򸡺(N)} -underline 5 -accelerator "F3" -command searchNext
	.menu.edit add command -label {ִ(E)...} -underline 3 -accelerator "Ctrl+H" -command {search 1}
	.menu.edit add command -label {Ԥذư(G)...} -underline 5 -accelerator "Ctrl+G" -command goto
	.menu.edit add separator
	.menu.edit add command -label {٤(A)} -underline 6 -accelerator "Ctrl+A" -command selectAll
	.menu.edit add command -label {դȻ(D)} -underline 6 -accelerator "F5" -command printTime

	menu .menu.form -tearoff no
	.menu.form add check -label {üޤ֤(W)} -underline 8 -command wrap

	menu .menu.help -tearoff no
	.menu.help add command -label {С(A)} -underline 8 -command showAbout

	. configure -menu .menu
}

# ݥåץåץ˥塼
proc createPopup {} {
	menu .popup -tearoff no
	.popup add command -label {᤹(U)} -underline 5 -command undo
	.popup add command -label {ľ(R)} -underline 5 -command redo
	.popup add separator
	.popup add command -label {ڤ(T)} -underline 5 -command cut
	.popup add command -label {ԡ(C)} -underline 4 -command copy
	.popup add command -label {Žդ(P)} -underline 5 -command paste
	.popup add command -label {(D)} -underline 3 -command delete
	.popup add separator
	.popup add command -label {٤(A)} -underline 6 -command selectAll

	bind . <3> { tk_popup .popup %X %Y }
}

# Хɺ
proc createBind {} {

	bind .t	<F3> 		{searchNext;	break}
	bind .t	<F5> 		{printTime;		break}
	bind .t <Tab> 		{indent;		break}
	bind .t <Shift-Tab>	{unIndent;		break}
	bind .t <Control-n> {newFile;		break}
	bind .t <Control-o> {loadFile;		break}
	bind .t <Control-s> {overwriteFile;	break}
	bind .t <Control-c> {copy;			break}
	bind .t <Control-x> {cut;			break}
	bind .t <Control-v> {paste;			break}
	bind .t <Control-z> {undo;			break}
	bind .t <Control-y> {redo;			break}
	bind .t <Control-f> {search 0;		break}
	bind .t <Control-a> {selectAll;		break}
	bind .t <Control-g> {goto;			break}
	bind .t <Control-h> {search 1;		break}
	bind .t <Control-p> {printout;		break}

	bind Button <Key-Return> {%W invoke}
}

# ƥȺ
proc createText {} {
	global tcl_platform

	text .t	-width 64 -height 20 \
			-yscroll {.sv set} -xscroll {.sh set} \
			-wrap none \
			-undo 1

	# ե
	if {$tcl_platform(platform) == "windows"} {
		.t config -font {{ͣ å} 14 normal}
		.t configure -font
	} else {
		.t config -font k14
		.t configure -font
	}

	scrollbar .sv -takefocus 0 -command {.t yview}
	scrollbar .sh -takefocus 0 -orient horizontal -command {.t xview}

	grid .t -in . -row 0 -column 0 -sticky nsew
	grid .sv -in . -row 0 -column 1 -sticky ns
	grid .sh -sticky we
	grid columnconfigure . 0 -weight 1
	grid rowconfigure . 0 -weight 1
}

# ޤ֤
proc wrap {} {
    global gWraps
    if {$gWraps == 0} {
		set gWraps 1
	    .t configure -wrap word
    } else {
		set gWraps 0
	    .t configure -wrap none
    }
}

# ֥
proc indent {} {

	# ϰϤФϰϤ򥤥ǥ

    set range [.t tag ranges sel]

	# ϰϤʤФTab
    if {[llength $range] == 0} {
		.t insert [ .t index insert ] "\t"
		return
	}

	set begin [lindex $range 0]
	set end [lindex $range 1]

	# ϰϤԤʤTab
	if {[.t compare "$begin linestart" == "$end linestart"] == 1} {
		.t delete sel.first sel.last
		.t insert [ .t index insert ] "\t"
		return
	}

	set pos "$begin linestart"
	while {[.t compare $pos < $end] == 1} {
        .t insert $pos "\t"
		set pos "$pos + 1 lines"
	}

	# ϰϤ
	#set pos "$end - 1 lines"
	set pos "$pos linestart"
	if {[.t compare $end == $pos] == 1} {
		.t tag add sel "$begin linestart" $end
	} else {
		set pos "$end + 1 lines"
		set pos "$pos linestart"
		.t tag add sel "$begin linestart" $pos

		# ư
		.t mark set insert $pos
	}
}

# եǥ
proc unIndent {} {

	# ϰϤФϰϤեǥ

    set range [.t tag ranges sel]

	# ϰϤʤв⤷ʤ
    if {[llength $range] == 0} {
		return
	}

	set begin [lindex $range 0]
	set end [lindex $range 1]

	set pos "$begin linestart"
	while {[.t compare $pos < $end] == 1} {
		if { [.t get $pos "$pos + 1 chars"] == "\t" } {
			.t delete $pos
		}
		set pos "$pos + 1 lines"
	}

	# ϰϤ
	#set pos "$end - 1 lines"
	set pos "$pos linestart"
	if {[.t compare $end == $pos] == 1} {
		.t tag add sel "$begin linestart" $end
	} else {
		set pos "$end + 1 lines"
		set pos "$pos linestart"
		.t tag add sel "$begin linestart" $pos

		# ư
		.t mark set insert $pos
	}
}

# ԡ
proc copy {} {
	tk_textCopy .t
}

# å
proc cut {} {
	tk_textCut .t
}

# ڡ
proc paste {} {
	tk_textPaste .t

	# Žդ֤˥ӥ塼ư
	.t see [.t index insert]
}

# 
proc delete {} {
	# 򤬤к
    if {[llength [.t tag ranges sel] ] != 0} {
		.t delete sel.first sel.last
	}
}

# ɥ
proc undo {} {
	catch {
		.t edit undo
	}
}

# ɥ
proc redo {} {
	catch {
		.t edit redo
	}
}

# 
proc newFile {} {
	global gFilename

	# եѹ¸䤦
	if {[querySave]==1} {
		return
	}

	.t delete 1.0 end

	# ɥȥɥΥå򥯥ꥢ
	.t edit reset

	# ѹޤä
	.t edit modified 0

	# ɥץѹ
	set gFilename ""
	updateCaption
}

# ե򳫤
proc loadFile {} {
	global gFilename

	# եѹ¸䤦
	if {[querySave]==1} {
		return
	}

	set ftypes {
		{"ƥʸ"	{.txt}  TEXT}
		{"٤ƤΥե"	*}
	}

	set newFilename $gFilename

	# ե̾
	set newFilename [tk_getOpenFile -filetypes $ftypes -parent . -title ] 
	if {$newFilename == ""} {
		return
	}

	set contents ""
	if { [ file readable $newFilename ] } {
		set fileid [ open $newFilename "r" ]
		set contents [ read -nonewline $fileid ]
		close $fileid
	}

	.t delete 1.0 end
	.t insert 1.0 $contents
	.t see 1.0;
	.t mark set insert 1.0

	set gFilename $newFilename

	# ɥȥɥΥå򥯥ꥢ
	.t edit reset

	# ѹޤä
	.t edit modified 0

	# ɥץѹ
	updateCaption
}

# ̾դ¸
proc saveFileAs {} {
	global gFilename

	set filename $gFilename
	if { $filename == "" } {
		set filename {*.txt}
	} 

	set ftypes {
		{"ƥʸ"	{.txt}	  TEXT}
		{"٤ƤΥե"	*}
	}

	set newFilename ""

	# ֥ե̾
	set newFilename [tk_getSaveFile -filetypes $ftypes \
			-parent . -initialfile $filename \
			-title ̾դ¸ ]

	if { $newFilename == "" } {
		return 0;
	} 

	set gFilename $newFilename

	saveFileAsSub

	# ѹޤä
	.t edit modified 0

	# ɥץѹ
	updateCaption


	return 1
}

# ̾ǥե¸
proc saveFileAsSub {} {
	global gFilename
	set contents [ .t get 1.0 end ]
	set fileid [ open $gFilename "w" ]
	puts -nonewline $fileid $contents
	close $fileid
}

# ¸
proc overwriteFile {} {
	global gFilename

	if {$gFilename==""} {
		return [saveFileAs]
	} else {
		saveFileAsSub

		# ѹޤä
		.t edit modified 0

		return 1
	}
}

# 
proc selectAll {} {
	.t tag add sel 1.0 end
}

# ɥץ
proc updateCaption {} {
	global gFilename gApplicationName

	set filename $gFilename

	if {$filename==""} {
		set filename "̵"
	} else {
		set filename [file tail $filename]
	}
	wm title . "$filename - $gApplicationName"
}

# Ԥذư
proc goto {} {
	global gGotoLineNumber

	set gGotoLineNumber ""

	toplevel .gotoDialog
	wm resizable .gotoDialog 0 0

	set x [winfo rootx .]
	set y [expr [winfo rooty .] -100]
	wm geometry .gotoDialog 242x86+[expr ${x}+ 60]+[expr ${y}+250]

	wm title .gotoDialog "Ԥذư"

	label .gotoDialog.l1 -text "ֹ(L):" -underline 4
	entry .gotoDialog.e1	-textvariable gGotoLineNumber \
							-bg white -selectbackground navy \
							-selectf white

	button .gotoDialog.b1 -text "OK" -command gotoOK
	button .gotoDialog.b2 -text "󥻥" -command gotoCancel

	place .gotoDialog.l1 -x 9 -y 11 -anchor nw
	place .gotoDialog.e1 -x 96 -y 11 -width 100 -height 18 -anchor nw 
	place .gotoDialog.b1 -x 12 -y 51 -width 88 -height 21 -anchor nw
	place .gotoDialog.b2 -x 137 -y 51 -width 88 -height 21 -anchor nw

	bind .gotoDialog <Return> gotoOK
	bind .gotoDialog <Alt-l> {focusEntry .gotoDialog.e1}
	bind .gotoDialog <l>	{
		if [focus] != .gotoDialog.e1 {focusEntry .gotoDialog.e1}
	}
	bind .gotoDialog <Escape>	".gotoDialog.b2 invoke"


	# ߤιԤɽ򤷤Ƥ
	.gotoDialog.e1 insert 0 [getLineNumber [.t index insert]]

	focusEntry .gotoDialog.e1

    grab set .gotoDialog

	tkwait window .gotoDialog
}

proc gotoOK {} {
	global gApplicationName
	global gGotoLineNumber

	# ϰϥåɬפ
	set max [getLineNumber [.t index end]]
	if { $gGotoLineNumber <= 0 || $gGotoLineNumber >= $max} {
		tk_messageBox	-title "$gApplicationName - Ԥ˰ư" \
						-message "ֹ椬ϰϳǤ" \
						-type ok

		# ߤιԤɽ򤷤Ƥ
		.gotoDialog.e1 delete 0 end
		.gotoDialog.e1 insert 0 [getLineNumber [.t index insert]]
		focusEntry .gotoDialog.e1
		focus -force .gotoDialog.e1
		return
	}

	set index "$gGotoLineNumber.0"
	.t mark set insert $index
	.t see $index

	destroy .gotoDialog
}

proc gotoCancel {} {
	destroy .gotoDialog
}

# Կ. ԿФ
proc getLineNumber { index } {
	set pos [string last {.} "$index"]
	return [string range $index 0 [expr $pos - 1]]
}

# Υȥ꡼ͤ
proc getEntryValue {} {
	global gSearchWord gReplaceWord
	global gEntrySearchWord gEntryReplaceWord
	global gSearchMode

	# ȥ꡼鸡ʸ
	if { [winfo exists .searchDialog] } {
		set gSearchWord $gEntrySearchWord

		# ִξִʸɬפ
		if {$gSearchMode==1} {
			set gReplaceWord $gEntryReplaceWord
		}
	}
}

# 򸡺
proc searchNext {} {
	global gSearchWord gSearchDirection
	global gSearchCase 
	global gSearchMode
	global gApplicationName

	if {$gSearchWord == ""} {
		search 0
	} else {
		if {$gSearchDirection==0} {
			# 
			set beginPos [.t index insert]
			set endPos 1.0

			# ϰϤФľ鸡
		    set range [.t tag ranges sel]
		    if {[llength $range] != 0} {
				set beginPos [.t index sel.first]
			}

			# 
			if {$gSearchCase==0} {
				set index [.t search -backward -nocase $gSearchWord $beginPos $endPos] 
			} else {
				set index [.t search -backward $gSearchWord $beginPos $endPos] 
			}
		} else {
			# 

			set beginPos [.t index insert]
			set endPos [.t index end]

			# ϰϤФľ夫鸡
		    set range [.t tag ranges sel]
		    if {[llength $range] != 0} {
				set beginPos [.t index sel.last]
			}

			# 
			if {$gSearchCase==0} {
				set index [.t search -forward -nocase $gSearchWord $beginPos $endPos] 
			} else {
				set index [.t search -forward -exact $gSearchWord $beginPos $endPos] 
			}
		}

		if { $index != "" } {
			# 򤬤к
		    if {[llength [.t tag ranges sel] ] != 0} {
				.t tag remove sel sel.first sel.last
			}

			.t see $index

			.t tag add sel $index "$index + [string length $gSearchWord] chars"

			# åȤϰϤ
			.t mark set insert [.t index sel.last]

			#focus -force .t
		} else {
			# Ĥʤä
			set parent .
			if { [winfo exists .searchDialog] } {
				set parent .searchDialog
			}
			tk_messageBox	-title $gApplicationName \
							-message "\"$gSearchWord\" Ĥޤ" \
							-parent $parent
		}
	}
}

# ȥ꡼˥ե뤫
proc isFocused {} {
	if { [focus] == {.searchDialog.e1} || [focus] == {.searchDialog.e2} } {
		return 1
	}
	return 0
}

# ȥ꡼˥եͿ
proc focusEntry {win} {
	focus $win
	$win selection range 0 end
	$win icursor end
}

# 
proc search {mode} {

	global gSearchWord gSearchDirection gSearchCase
	global gEntrySearchWord gEntryReplaceWord
	global gSearchMode

	set gSearchMode $mode

	# ˥ФƤν
	if { [winfo exists .searchDialog] } {
		# ե
		focusEntry .searchDialog.e1
		return
	}

	# 
	set gSearchDirection 1
	set gSearchCase 0
	set gEntrySearchWord ""
	set gEntryReplaceWord ""

	catch "destroy .searchDialog"

	set x [winfo rootx .]
	set y [expr [winfo rooty .] -100]
	toplevel .searchDialog
	wm resizable .searchDialog 0 0

	if {$mode == 0} {
		wm title .searchDialog ""
		wm geometry .searchDialog 481x104+[expr ${x}+ 60]+[expr ${y}+250]

		label .searchDialog.l1 -text "ʸ(N):" -underline 8
		entry .searchDialog.e1	-textvariable gEntrySearchWord \
								-bg white -selectbackground navy \
								-selectf white

		button .searchDialog.b1 -text 򸡺(F) -underline 5 -command {getEntryValue; searchNext}
		button .searchDialog.b2 -text "󥻥" -command "destroy .searchDialog"

		checkbutton	.searchDialog.c1	-text "ʸȾʸ̤(C)" -underline 13 \
										-variable gSearchCase -offvalue 0 -onvalue 1

		labelframe	.searchDialog.f1 -bd 2 -relief groove -text 
		radiobutton	.searchDialog.f1.r1 -text "(U)" -underline 3 -variable gSearchDirection -value 0
		radiobutton	.searchDialog.f1.r2 -text "(D)" -underline 3 -variable gSearchDirection -value 1

		place .searchDialog.l1 -x 4 -y 11 -anchor nw
		place .searchDialog.e1 -x 131 -y 11 -width 242 -height 18 -anchor nw 
		place .searchDialog.b1 -x 385 -y 8 -width 88 -height 21 -anchor nw
		place .searchDialog.b2 -x 385 -y 35 -width 88 -height 21 -anchor nw

		place .searchDialog.c1 -x 2 -y 67 -anchor nw

		place .searchDialog.f1 -x 219 -y 47 -width 154 -height 42 -anchor nw
		place .searchDialog.f1.r1 -x 4 -y 2 -width 60 -height 16 -anchor nw 
		place .searchDialog.f1.r2 -x 77 -y 2 -width 60 -height 16 -anchor nw
	} else {
		wm title .searchDialog "ִ"
		wm geometry .searchDialog 480x152+[expr ${x}+ 60]+[expr ${y}+250]

		label .searchDialog.l1 -text "ʸ(N):" -underline 8
		label .searchDialog.l2 -text "ִʸ(P):" -underline 8

		entry .searchDialog.e1	-textvariable gEntrySearchWord \
								-bg white -selectbackground navy \
								-selectf white

		entry .searchDialog.e2	-textvariable gEntryReplaceWord \
								-bg white -selectbackground navy \
								-selectf white

		button .searchDialog.b1 -text 򸡺(F) -underline 5 -command {getEntryValue; searchNext}
		button .searchDialog.b2 -text ִƼ(R) -underline 7 -command replaceSub
		button .searchDialog.b3 -text ٤ִ(A) -underline 6 -command replaceAll
		button .searchDialog.b4 -text "󥻥" -command "destroy .searchDialog"

		checkbutton	.searchDialog.c1	-text "ʸȾʸ̤(C)" -underline 13 \
										-variable gSearchCase -offvalue 0 -onvalue 1

		place .searchDialog.l1 -x 4 -y 11 -anchor nw
		place .searchDialog.l2 -x 4 -y 39 -anchor nw
		place .searchDialog.e1 -x 137 -y 11 -width 207 -height 18 -anchor nw 
		place .searchDialog.e2 -x 137 -y 39 -width 207 -height 18 -anchor nw 

		place .searchDialog.b1 -x 357 -y 6 -width 110 -height 21 -anchor nw
		place .searchDialog.b2 -x 357 -y 33 -width 110 -height 21 -anchor nw
		place .searchDialog.b3 -x 357 -y 60 -width 110 -height 21 -anchor nw
		place .searchDialog.b4 -x 357 -y 87 -width 110 -height 21 -anchor nw

		place .searchDialog.c1 -x 9 -y 99 -anchor nw
	}

	# Х
	# ȥ˥եȤAlt+...ͭ
	# Ǥʤϥ󥭡ǤͭȤΤºݤΥĢư
	bind .searchDialog <Alt-f>	".searchDialog.b1 invoke"
	bind .searchDialog <f>	{ if [isFocused]==0 {.searchDialog.b1 invoke} }
	bind .searchDialog <Return>	".searchDialog.b1 invoke"

	bind .searchDialog <Alt-c>	".searchDialog.c1 invoke"
	bind .searchDialog <c>	{ if [isFocused]==0 {.searchDialog.c1 invoke} }

	bind .searchDialog <Alt-n>	"focusEntry .searchDialog.e1"
	bind .searchDialog <n>	{ if [isFocused]==0 {focusEntry .searchDialog.e1} }

	if {$gSearchMode==0} {
		bind .searchDialog <Alt-u>	".searchDialog.f1.r1 invoke"
		bind .searchDialog <Alt-d>	".searchDialog.f1.r2 invoke"
		bind .searchDialog <u>	{ if [isFocused]==0 {.searchDialog.f1.r1 invoke} }
		bind .searchDialog <d>	{ if [isFocused]==0 {.searchDialog.f1.r2 invoke} }
		bind .searchDialog <Escape>	".searchDialog.b2 invoke"
	} else {
		bind .searchDialog <Alt-r>	".searchDialog.b2 invoke"
		bind .searchDialog <Alt-a>	".searchDialog.b3 invoke"
		bind .searchDialog <Alt-p>	"focusEntry .searchDialog.e2"
		bind .searchDialog <r>	{ if [isFocused]==0 {.searchDialog.b2 invoke} }
		bind .searchDialog <a>	{ if [isFocused]==0 {.searchDialog.b3 invoke} }
		bind .searchDialog <p>	{ if [isFocused]==0 {focusEntry .searchDialog.e2} }
		bind .searchDialog <Escape>	".searchDialog.b4 invoke"
	}

	.searchDialog.e1 insert 0 $gSearchWord
	focusEntry .searchDialog.e1
}


# ִƼ
proc replaceSub {} {
	
	global gSearchWord gReplaceWord gSearchCase

	getEntryValue

	# ʸ򤷤Ƥ
	# ִʸִ
	if {[llength [.t tag ranges sel] ] != 0 } {
		
		if {$gSearchCase==0} {
			if { [string compare -nocase [.t get sel.first sel.last] $gSearchWord] != 0} {
				return
			}
		} else {
			if { [string compare [.t get sel.first sel.last] $gSearchWord] != 0} {
				return
			}
		}
		
		# ִ
		set index [.t index sel.first]
		set length [string length $gSearchWord]

		.t tag remove sel sel.first sel.last;		# ϰϺ
		.t delete $index "$index + $length chars";	# 
		.t insert $index $gReplaceWord;				# 
		
		# ִ饹뤷
		# ϰϤˤ
		# åȤϰϤΰָ
		set length [string length $gReplaceWord]
		.t see $index
		.t tag add sel $index "$index + $length chars"
		.t mark set insert [.t index sel.last]
	}
	searchNext
}


# ٤ִ
proc replaceAll {} {
	global gSearchWord gReplaceWord gSearchCase

	getEntryValue

	# ϰϤϤʤʤꥭåȤƬ

	# 򤬤к
    if {[llength [.t tag ranges sel] ] != 0} {
		.t tag remove sel sel.first sel.last
	}

	# ִ
	set length1 [string length $gSearchWord]
	set length2 [string length $gReplaceWord]
	set index 1.0
	while {1} {
		# 
		if {$gSearchCase==0} {
			set index [.t search -forward -nocase $gSearchWord $index end] 
		} else {
			set index [.t search -forward -exact $gSearchWord $index end] 
		}

		if {$index == ""} {
			.t see 1.0;				# 
			.t mark set insert 1.0;	# åȤƬ
			return
		} else {
			.t delete $index "$index + $length1 chars";	# 
			.t insert $index $gReplaceWord;				# 
			set index [.t index "$index + $length2 chars"]
		}
	}
}

# λν
proc exitApplication {} {
	if {[querySave]==0} {
		destroy .
	}
}

# ֤뤫
# 0:λ
# 1:
proc querySave {} {

	global gFilename

	# ̵Ƥ̵Ͻλ
	if {$gFilename == ""
	&& [.t index {1.0 lineend}] == 1.0
	&& [.t index end] == 2.0 } {
		return 0
	}

	# ѹ̵Ͻλ
	if [isModified]==0	{
		return 0
	}

	switch [querySaveSub] {
		yes	{
			if {[overwriteFile]==1} {
				return 0
			} else {
				return 1
			}
		}
		no {
			return 0
		}
		cancel {
			return 1
		}
	}
}

# ¸뤫䤤碌
# yes no cancel ֤
proc querySaveSub {} {
	global gFilename
	global gApplicationName

	set filename $gFilename
	if {$filename == ""} {
		set filename ̵
	}

	return [tk_messageBox \
		-message "ե $filename ƤѹƤޤ\n\nѹ¸ޤ?" \
		-title $gApplicationName \
		-type yesnocancel \
		-icon warning]
}

# եƤѹä줿
proc isModified {} {
	return [.t edit modified]
}

# դȻ
proc printTime {} {
	.t insert insert [clock format [clock seconds] -format "%R %Y/%m/%d"]
}

#ץ
proc printout {} {
	global env
	set i [catch {exec lpr -P$env(PRINTER) << [ .t get 1.0 end ]}] 
}




#ư
proc onStartUp {} {
	global argc argv gFilename

	if {$argc == 1} { 
		set filename [lindex $argv 0]

		catch {
			set fileid [ open $filename "r" ]
			set contents [ read -nonewline $fileid ]
			close $fileid
			.t insert 1.0 $contents
		}

		set gFilename $filename

		# ɥȥɥΥå򥯥ꥢ
		.t edit reset

		# ѹޤä
		.t edit modified 0

		# ɥץѹ
		updateCaption
	}

	if {$argc >= 2} {
		puts ¿ޤ
		exit
	}
}






# ե
if {$tcl_platform(platform) == "windows"} {
    catch {option add *font {{MS UI Gothic} 9}}
} else {
    catch {option add *font k14}
}

# Хѿ
set gApplicationName "KNote";	# ץ̾
set gFilename "";				# ե̾
set gGotoLineNumber "";			# Ԥذưκݤιֹ

set gEntrySearchWord "";		# ȥ꡼ʸ
set gEntryReplaceWord "";		# ȥ꡼ʸ
set gSearchWord "";				# ʸ
set gReplaceWord "";			# ִʸ

set gSearchDirection 1;			#  0: 1:
set gSearchCase 0;				# 0:̾ 1:ʸȾʸ̤
set gSearchMode 0;				# 0: 1:ִ

set gWraps 0; 					# 0:ޤ֤ʤ 1:üޤ֤

updateCaption
createMenu
createPopup
createText
createBind

# ɥĤȤν
wm protocol . WM_DELETE_WINDOW exitApplication

# ޥɥ饤β
onStartUp

# Ū˥ե򤢤碌
#focus -force .t

# ե򥻥å
raise .
focus .t

